/*
 * packaging/windows_installer.nsi
 *
 * Copyright 2018 Kyle Stevenson <stevensonkd@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 * Includes.
 */

/* Modern UI. */
!include MUI2.nsh

/*
 * Definitions.
 */

/* Publishing information. */
!define PUBLISHER "Kyle Stevenson"
!define WEBSITE   "https://unmine.anarch.ca"

/* Registry keys. */
!define REGKEY_DIR    "Software\${NAME}"
!define REGKEY_UNINST "Software\Microsoft\Windows\CurrentVersion\Uninstall\${NAME}"

/*
 * Installer attributes.
 */

/* Set installer name */
Name "${NAME} ${VERSION}"

/* Set install directory. */
InstallDir "$PROGRAMFILES\${NAME}"

/* Set installer executable. */
OutFile "${BUILD_DIR}\${NAME}-${VERSION}-setup.exe"

/* Set version information */
VIProductVersion "0.1.0.0"
VIAddVersionKey "ProductName"     "${NAME}"
VIAddVersionKey "FileVersion"     "${VERSION}"
VIAddVersionKey "ProductVersion"  "${VERSION}"
VIAddVersionKey "LegalCopyright"  "Copyright 2015-2018 Kyle Stevenson"
VIAddVersionKey "FileDescription" "${NAME} Installer"

/* Force file integrity check. */
CRCCheck force

/* Request highest privileges available to the user. */
RequestExecutionLevel highest

/* Compress all files in one block, and use lzma. */
SetCompressor /SOLID lzma

/*
 * Modern UI configuration.
 */

/* Confirm before aborting installation/uninstallation. */
!define MUI_ABORTWARNING
!define MUI_UNABORTWARNING

/* Let the user check the install/uninstall log before finishing. */
!define MUI_FINISHPAGE_NOAUTOCLOSE
!define MUI_UNFINISHPAGE_NOAUTOCLOSE

/*
 * Pages.
 */

/* Welcome page. */
!insertmacro MUI_PAGE_WELCOME

/* License page. */
!insertmacro MUI_PAGE_LICENSE "LICENSE"

/* Components page. */
!define MUI_PAGE_CUSTOMFUNCTION_LEAVE ComponentsPageLeave
!insertmacro MUI_PAGE_COMPONENTS

/* Directory page. */
!insertmacro MUI_PAGE_DIRECTORY

/* Start menu page. */
Var start_menu_folder
!define MUI_STARTMENUPAGE_DEFAULTFOLDER      "${NAME}"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT      HKLM
!define MUI_STARTMENUPAGE_REGISTRY_KEY       "${REGKEY_UNINST}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "Start Menu Folder"
!insertmacro MUI_PAGE_STARTMENU "${NAME}" $start_menu_folder

/* Instfiles page. */
!insertmacro MUI_PAGE_INSTFILES

/* Finish page. */
!define MUI_FINISHPAGE_RUN
!define MUI_FINISHPAGE_RUN_FUNCTION "RunGame"
/*!define MUI_FINISHPAGE_RUN_TEXT "Play {NAME} now."*/
!insertmacro MUI_PAGE_FINISH
Function RunGame
    ExecShell "" "$INSTDIR\${NAME}.lnk"
FunctionEnd

/* Uninstaller page. */
!insertmacro MUI_UNPAGE_INSTFILES

/*
 * Language files.
 */

!insertmacro MUI_LANGUAGE "English"

/*
 * Sections.
 */

/* GUI section. */
Section "${NAME}-gui" SEC_GUI

    /* Install game and icons. */
    SetOutPath "$INSTDIR\bin"
    File /r "icons"
    File "${BUILD_DIR}\${NAME}-gui.exe"
    CreateShortCut "$INSTDIR\${NAME}-gui.lnk" "$INSTDIR\bin\${NAME}-gui.exe"

    /* Create Start Menu shortcuts. */
    !insertmacro MUI_STARTMENU_WRITE_BEGIN "${NAME}"
    CreateDirectory "$SMPROGRAMS\$start_menu_folder"
    CreateShortCut "$SMPROGRAMS\$start_menu_folder\${NAME}-gui.lnk" "$INSTDIR\bin\${NAME}-gui.exe"
    !insertmacro MUI_STARTMENU_WRITE_END

    /* Install GTK+3 files. */
    SetOutPath "$INSTDIR\bin"
    File "${MINGW_DIR}\bin\libatk-1.0-0.dll"
    File "${MINGW_DIR}\bin\libbz2-1.dll"
    File "${MINGW_DIR}\bin\libcairo-2.dll"
    File "${MINGW_DIR}\bin\libcairo-gobject-2.dll"
    File "${MINGW_DIR}\bin\libepoxy-0.dll"
    File "${MINGW_DIR}\bin\libexpat-1.dll"
    File "${MINGW_DIR}\bin\libffi-6.dll"
    File "${MINGW_DIR}\bin\libfontconfig-1.dll"
    File "${MINGW_DIR}\bin\libfreetype-6.dll"
    File "${MINGW_DIR}\bin\libfribidi-0.dll"
    File "${MINGW_DIR}\bin\libgcc_s_seh-1.dll"
    File "${MINGW_DIR}\bin\libgdk_pixbuf-2.0-0.dll"
    File "${MINGW_DIR}\bin\libgdk-3-0.dll"
    File "${MINGW_DIR}\bin\libgio-2.0-0.dll"
    File "${MINGW_DIR}\bin\libglib-2.0-0.dll"
    File "${MINGW_DIR}\bin\libgmodule-2.0-0.dll"
    File "${MINGW_DIR}\bin\libgobject-2.0-0.dll"
    File "${MINGW_DIR}\bin\libgraphite2.dll"
    File "${MINGW_DIR}\bin\libgtk-3-0.dll"
    File "${MINGW_DIR}\bin\libharfbuzz-0.dll"
    File "${MINGW_DIR}\bin\libiconv-2.dll"
    File "${MINGW_DIR}\bin\libintl-8.dll"
    File "${MINGW_DIR}\bin\libpango-1.0-0.dll"
    File "${MINGW_DIR}\bin\libpangocairo-1.0-0.dll"
    File "${MINGW_DIR}\bin\libpangoft2-1.0-0.dll"
    File "${MINGW_DIR}\bin\libpangowin32-1.0-0.dll"
    File "${MINGW_DIR}\bin\libpcre-1.dll"
    File "${MINGW_DIR}\bin\libpixman-1-0.dll"
    File "${MINGW_DIR}\bin\libpng16-16.dll"
    File "${MINGW_DIR}\bin\libstdc++-6.dll"
    File "${MINGW_DIR}\bin\zlib1.dll"

    SetOutPath "$INSTDIR\lib\gdk-pixbuf-2.0\2.10.0"
    File /r "${MINGW_DIR}\lib\gdk-pixbuf-2.0\2.10.0\loaders"
    File "${MINGW_DIR}\lib\gdk-pixbuf-2.0\2.10.0\loaders.cache"

    SetOutPath "$INSTDIR\share\icons"
    File /r "${MINGW_DIR}\share\icons\Adwaita"

 /* File /r "${MINGW_DIR}\share\locale" */

SectionEnd

/* TUI section. */
Section "${NAME}-tui" SEC_TUI

    /* Install game. */
    SetOutPath "$INSTDIR\bin"
    File "${BUILD_DIR}\${NAME}-tui.exe"
    CreateShortCut "$INSTDIR\${NAME}-tui.lnk" "$INSTDIR\bin\${NAME}-tui.exe"

    /* Create Start Menu shortcuts. */
    !insertmacro MUI_STARTMENU_WRITE_BEGIN "${NAME}"
    CreateDirectory "$SMPROGRAMS\$start_menu_folder"
    CreateShortCut "$SMPROGRAMS\$start_menu_folder\${NAME}-tui.lnk" "$INSTDIR\bin\${NAME}-tui.exe"
    !insertmacro MUI_STARTMENU_WRITE_END

SectionEnd

/* Required (hidden) section. */
Section -Required

    /* Install "documentation". */
    SetOutPath "$INSTDIR"
    File "/oname=LICENSE.txt" "LICENSE"
    File "/oname=ICON-LICENSE.txt" "ICON-LICENSE"
    File "/oname=NEWS.txt"    "NEWS"
    File "/oname=README.txt"  "README"

    /* Install libraries used by the core game. */
    SetOutPath "$INSTDIR\bin"
    File "${MINGW_DIR}\bin\libconfig-11.dll"
    File "${MINGW_DIR}\bin\libwinpthread-1.dll"

    /* Create the uninstaller. */
    WriteUninstaller "$INSTDIR\uninst.exe"

    /* Create registry key for configuration. */
 /* WriteRegStr   SHCTX "${REGKEY_DIR}"    Path                   "$INSTDIR" */

    /* Create an entry in the Add/Remove programs list. */
    /* Required keys. */
    WriteRegStr   SHCTX "${REGKEY_UNINST}" "DisplayName"          "${NAME}"
    WriteRegStr   SHCTX "${REGKEY_UNINST}" "UninstallString"      "$INSTDIR\uninst.exe"
    /* Recommended keys. */
    WriteRegStr   SHCTX "${REGKEY_UNINST}" "QuietUninstallString" "$INSTDIR\uninst.exe /S"
    /* Optional keys. */
    WriteRegStr   SHCTX "${REGKEY_UNINST}" "DisplayIcon"          "$INSTDIR\bin\${NAME}-gui.exe"
    WriteRegStr   SHCTX "${REGKEY_UNINST}" "DisplayVersion"       "${VERSION}"
    WriteRegStr   SHCTX "${REGKEY_UNINST}" "HelpLink"             "${WEBSITE}"
    WriteRegStr   SHCTX "${REGKEY_UNINST}" "InstallLocation"      "$INSTDIR"
    WriteRegStr   SHCTX "${REGKEY_UNINST}" "Publisher"            "${PUBLISHER}"
    WriteRegStr   SHCTX "${REGKEY_UNINST}" "Readme"               "$INSTDIR\README.txt"
    WriteRegStr   SHCTX "${REGKEY_UNINST}" "URLInfoAbout"         "${WEBSITE}"
    WriteRegStr   SHCTX "${REGKEY_UNINST}" "URLUpdateInfo"        "${WEBSITE}"
    WriteRegDWORD SHCTX "${REGKEY_UNINST}" "NoModify"             0x00000001
    WriteRegDWORD SHCTX "${REGKEY_UNINST}" "NoRepair"             0x00000001

SectionEnd

/* Uninstall section. */
Section "Uninstall"

    /* Delete game files. */
    Delete "$INSTDIR\${NAME}-gui.lnk"
    Delete "$INSTDIR\${NAME}-tui.lnk"
    Delete "$INSTDIR\ICON-LICENSE.txt"
    Delete "$INSTDIR\LICENSE.txt"
    Delete "$INSTDIR\NEWS.txt"
    Delete "$INSTDIR\README.txt"
    Delete "$INSTDIR\uninst.exe"

    /* Delete library files. */
    RMDir /r "$INSTDIR\bin"
    RMDir /r "$INSTDIR\lib"
    RMDir /r "$INSTDIR\share"

    /* Delete install directory. */
    RMDir "$INSTDIR"

    /* Delete Start Menu shortcuts. */
    !insertmacro MUI_STARTMENU_GETFOLDER "${NAME}" $R0
    Delete "$SMPROGRAMS\$R0\${NAME}-gui.lnk"
    Delete "$SMPROGRAMS\$R0\${NAME}-tui.lnk"
    RMDir "$SMPROGRAMS\$R0"

    /* Delete registry keys. */
 /* DeleteRegKey SHCTX "${REGKEY_DIR}" */
    DeleteRegKey HKCU "${REGKEY_UNINST}"
    DeleteRegKey HKLM "${REGKEY_UNINST}"

SectionEnd

/* Ensure at least one interface is selected. */
Function ComponentsPageLeave
    ${Unless} ${SectionIsSelected} ${SEC_GUI}
    ${AndUnless} ${SectionIsSelected} ${SEC_TUI}
        MessageBox MB_OK|MB_ICONINFORMATION "You have to select an interface to play unmine. You probably want the GUI!"
        Abort
    ${EndUnless}
FunctionEnd

/*
 * Section Descriptions.
 */

!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
!insertmacro MUI_DESCRIPTION_TEXT ${SEC_GUI} "Graphical interface based on the GTK+ 3 Runtime Environment. You probably want this one."
!insertmacro MUI_DESCRIPTION_TEXT ${SEC_TUI} "A terminal interface based on ncurses. For a retro feel!"
!insertmacro MUI_FUNCTION_DESCRIPTION_END
