/*
 * unmine/classic_config.h
 *
 * Copyright 2016 Kyle Stevenson <stevensonkd@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef UM_CLASSIC_CONFIG_
#define UM_CLASSIC_CONFIG_

#include <libconfig.h>

#include "classic.h"

/*
 * Functions.
 */

/*
 * Add configuration settings for classic game options to the given group. This
 * can be called repeatedly with the same group to populate missing settings.
 */
void um_classic_config_create_options(config_setting_t *group);

/*
 * Add configuration settings for classic game parameters to the given group.
 * This can be called repeatedly with the same group to populate missing
 * settings.
 */
void um_classic_config_create_parameters(config_setting_t *group);

/*
 * Convenience function; calls functions um_classic_config_load_*, and calls
 * functions um_classic_config_create_* to fill in missing settings.
 */
void um_classic_config_load(config_setting_t *group, ClassicOptions *options,
                            ClassicParameters *params);

/*
 * Load classic game options from the configuration group. No changes are made
 * to options with missing or invalid settings. Returns 1 if one or more
 * settings are missing or invalid, otherwise 0.
 */
int um_classic_config_load_options(config_setting_t *group,
                                    ClassicOptions *options);

/*
 * Load classic game parameters from the configuration group. No changes are
 * made to parameters with missing or invalid settings. Returns 1 if one or
 * more settings are missing or invalid, otherwise 0.
 */
int um_classic_config_load_parameters(config_setting_t *group,
                                        ClassicParameters *params);

/*
 * Convenience function; calls functions um_classic_config_save_*.
 */
void um_classic_config_save(config_setting_t *group, ClassicOptions *options,
                            ClassicParameters *params);

/*
 * Save classic game options into the configuration group. No changes are made
 * to missing or invalid settings. Returns 1 if one or more settings are
 * missing or invalid, otherwise 0.
 */
int um_classic_config_save_options(config_setting_t *group,
                                    ClassicOptions *options);

/*
 * Save classic game parameters into the configuration group. No changes are
 * made to missing or invalid settings. Returns 1 if one or more settings are
 * missing or invalid, otherwise 0.
 */
int um_classic_config_save_parameters(config_setting_t *group,
                                        ClassicParameters *params);

#endif /* UM_CLASSIC_CONFIG_ */
