/*
 * unmine/flags_ai.h
 *
 * Copyright 2018 Kyle Stevenson <stevensonkd@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef UM_FLAGS_AI_
#define UM_FLAGS_AI_

#include "coords.h"
#include "tile.h"

/*
 * Types.
 */

typedef struct {
    Coords coords;
    int bomb;
} FlagsAIDecision;

typedef enum {
    NO_AI,
    RANDOM, /* selects random coords, no bomb */
    ODDS, /* selects the tile most likely to be a mine */
    CAUTIOUS, /* selects the safest move */
    NOVICE,
    JUNIOR,
    INTERMEDIATE,
    ADVANCED,
    MASTER,
    NUM_AI_LEVELS
} FlagsAILevel;

/*
 * Constants.
 */

extern const FlagsAILevel UM_FLAGS_AI_DEFAULT;

/*
 * Strings.
 */
const char * const UM_FLAGS_AI_LEVEL_NAMES[NUM_AI_LEVELS];

/*
 * Functions.
 */

/*
 * Decide a player's next action based on the given skill level or strategy.
 */
FlagsAIDecision um_flags_ai_decide(FlagsAILevel level, Tile **tiles, int width,
                                    int height);

#endif /* UM_FLAGS_AI_ */
