/*
 * unmine/gui_classic.h
 *
 * Copyright 2016 Kyle Stevenson <stevensonkd@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef UM_GUI_CLASSIC_
#define UM_GUI_CLASSIC_

#include <gtk/gtk.h>
#include <libconfig.h>

/*
 * Types.
 */

typedef struct GUIClassic GUIClassic;

/*
 * Functions.
 */

/*
 * Initialize the interface.
 */
GUIClassic * um_gui_classic_init(GtkWidget *window, config_setting_t *config);

/*
 * Destroy the interface.
 */
void um_gui_classic_destroy(GUIClassic *gui);

/*
 * Get the 'Classic Options' menu widget (GtkMenuItem).
 */
GtkWidget * um_gui_classic_get_menu(GUIClassic *gui);

/*
 * Get the top-level container widget (GtkBox).
 */
GtkWidget * um_gui_classic_get_ui(GUIClassic *gui);

#endif /* UM_GUI_CLASSIC_ */
