/*
 * unmine/gui_params.h
 *
 * Copyright 2017 Kyle Stevenson <stevensonkd@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef UM_GUI_PARAMS_
#define UM_GUI_PARAMS_

#include <gdk/gdk.h>
#include <gtk/gtk.h>

/*
 * Types.
 */

typedef struct GUIParams GUIParams;

/*
 * Functions.
 */

/*
 * Create a new GUIParams dialog with the given minimum and maximum values.
 * Returns a pointer to the new dialog, or NULL.
 */
GUIParams * um_gui_params_create(GtkWidget *window, int width_min,
                                    int height_min, int num_mines_min,
                                    int width_max, int height_max,
                                    int num_mines_max);

/*
 * Destroy the GUIParams dialog.
 */
void um_gui_params_destroy(GUIParams *params);

/*
 * Prompt the user for parameters. Returns 1 if parameters change, otherwise 0.
 */
int um_gui_params_prompt(GUIParams *params, int *width, int *height,
                            int *num_mines);

#endif /* UM_GUI_PARAMS_ */
