/*
 * unmine/tile.c
 *
 * Copyright 2018 Kyle Stevenson <stevensonkd@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "tile.h"

#include <stdlib.h>

/*
 * Public functions.
 */

/*
 * Returns 1 if the given Tiles are neighbours.
 */
int um_tile_is_neighbour(const Tile *a, const Tile *b) {
    int dx = a->x - b->x,
        dy = a->y - b->y;
    return dx >= -1 && dx <= 1 && dy >= -1 && dy <= 1;
}

/*
 * Populates the given array with Tiles neighbouring the given Tile; neighbours
 * that don't exist (because the tile is on an edge) are NULL.
 */
void um_tile_neighbours(Tile **tiles, const Tile *tile, int width, int height,
                        Tile *neighbours[8]) {
    int u = (tile->y - 1 >= 0),
        d = (tile->y + 1 < height),
        l = (tile->x - 1 >= 0),
        r = (tile->x + 1 < width);
    neighbours[0] = (u && l) ? &tiles[tile->x - 1][tile->y - 1] : NULL;
    neighbours[1] = (u)      ? &tiles[tile->x    ][tile->y - 1] : NULL;
    neighbours[2] = (u && r) ? &tiles[tile->x + 1][tile->y - 1] : NULL;
    neighbours[3] = (l)      ? &tiles[tile->x - 1][tile->y]     : NULL;
    neighbours[4] = (r)      ? &tiles[tile->x + 1][tile->y]     : NULL;
    neighbours[5] = (d && l) ? &tiles[tile->x - 1][tile->y + 1] : NULL;
    neighbours[6] = (d)      ? &tiles[tile->x    ][tile->y + 1] : NULL;
    neighbours[7] = (d && r) ? &tiles[tile->x + 1][tile->y + 1] : NULL;
}
