/*
 * unmine/tile.h
 *
 * Copyright 2018 Kyle Stevenson <stevensonkd@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef UM_TILE_
#define UM_TILE_

/*
 * Types.
 */

typedef struct {
    int x, y, revealed, mined, count, face, last;
} Tile;

/*
 * Functions.
 */

/*
 * Returns 1 if the given Tiles are neighbours.
 */
int um_tile_is_neighbour(const Tile *a, const Tile *b);

/*
 * Populates the given array with Tiles neighbouring the given Tile; neighbours
 * that don't exist (because the tile is on an edge) are NULL.
 */
void um_tile_neighbours(Tile **tiles, const Tile *tile, int width, int height,
                        Tile *neighbours[8]);

#endif /* UM_TILE_ */
