/*
 * unmine/tui_common.h
 *
 * Copyright 2018 Kyle Stevenson <stevensonkd@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef UM_TUI_COMMON_
#define UM_TUI_COMMON_

#include <libconfig.h>

/*
 * Functions.
 */

#define UM_TUI_BOARD_DIM(val, zoom)  (((zoom) + 1) * (val) - (zoom))
#define UM_TUI_BOARD_X(width, zoom)  \
    (UM_TUI_CENTER(COLS, UM_TUI_BOARD_DIM(width, zoom)))
#define UM_TUI_BOARD_Y(height, zoom) \
    (UM_TUI_CENTER(LINES, UM_TUI_BOARD_DIM(height, zoom)))
#define UM_TUI_CENTER(box_dim, item_dim) (((box_dim) - (item_dim)) / 2)

/*
 * Display a dialog allowing the user to change board parameters. Returns 1 if
 * any parameter is changed.
 */
int um_tui_board_params(const char *title, int params[3], const int mins[3],
                        int selection);

/*
 * Load zoom from config.
 */
void um_tui_config_load_zoom(config_setting_t *config, int *zoom);

/*
 * Save zoom to config.
 */
void um_tui_config_save_zoom(config_setting_t *config, int zoom);

/*
 * Draw the program name, version, and (optionally) a title and subtitle for
 * the current screen in the top left corner, and (optionally) help/directions
 * in the bottom left corner.
 */
void um_tui_draw_meta(const char *title, const char *subtitle,
                        const char * const *directions,
                        int directions_length);

/*
 * Returns 1 if the given key should quit the current screen.
 */
int um_tui_is_quit_key(int key);

/*
 * Returns 1 if the window size has changed since the last time this was called
 * (returns 1 the first time it's called).
 */
int um_tui_is_size_changed(void);

/*
 * Returns positive i mod n.
 */
int um_tui_positive_modulo(int i, int n);

#endif /* UM_TUI_COMMON_ */
